<?php
namespace App\Http\Controllers\AdminControllers;

use App\Http\Controllers\Controller;
use App\Models\Setting;
use App\Services\CachingService;
use App\Services\FileService;
use App\Services\ResponseService;
use Illuminate\Http\Request;
use Throwable;

class SubscriptionModelController extends Controller
{
    private string $uploadFolder;

    public function __construct()
    {
        $this->uploadFolder = 'settings';
    }

    public function store(Request $request)
    {
        ResponseService::noPermissionThenSendJson('subscription-model-and-header/footer-script-settings');

        try {
            // Validate file inputs
            $request->validate([
                'subscribe_model_image' => 'nullable|file|image|max:2048', // Add this
            ]);

            $inputs = $request->input();
            unset($inputs['_token']);
            $data = [];
            foreach ($inputs as $key => $input) {
                $data[] = [
                    'name'  => $key,
                    'value' => $input,
                    'type'  => 'string',
                ];
            }

            // Set upload folder
            $this->uploadFolder = 'settings';

            // Fetch old images to delete from disk storage
            $oldSettingFiles = Setting::whereIn('name', collect($request->files)->keys())->get();
            foreach ($request->files as $key => $file) {
                if ($request->hasFile($key)) {
                    $filePath = $request->file($key)->store($this->uploadFolder, 'public');
                    $data[]   = [
                        'name'  => $key,
                        'value' => $filePath,
                        'type'  => 'file',
                    ];
                    $oldFile = $oldSettingFiles->first(function ($old) use ($key) {
                        return $old->name == $key;
                    });
                    if (! empty($oldFile)) {
                        FileService::delete($oldFile->getRawOriginal('value'));
                    }
                }
            }

            Setting::upsert($data, 'name', ['value']);
            CachingService::removeCache(config('constants.CACHE.SETTINGS'));
            return redirect()->back()->with('success', 'Settings Updated Successfully!!');

        } catch (Throwable $th) {
            ResponseService::logErrorResponse($th, "Setting Controller -> store");
            ResponseService::errorResponse('Something Went Wrong');
        }
    }
}
